/*********************************************************************
 *
 *  Legacy Demo Code for:
 *	  - Classic HTTP server
 *    - FTP uploads of MPFS image
 *
 *********************************************************************
 * FileName:        LegacyHTTPApp.c
 * Dependencies:    TCP/IP stack
 * Processor:       PIC18, PIC24F, PIC24H, dsPIC30F, dsPIC33F, PIC32
 * Compiler:        Microchip C32 v1.05 or higher
 *					Microchip C30 v3.12 or higher
 *					Microchip C18 v3.30 or higher
 *					HI-TECH PICC-18 PRO 9.63PL2 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * Copyright (C) 2002-2009 Microchip Technology Inc.  All rights
 * reserved.
 *
 * Microchip licenses to you the right to use, modify, copy, and
 * distribute:
 * (i)  the Software when embedded on a Microchip microcontroller or
 *      digital signal controller product ("Device") which is
 *      integrated into Licensee's product; or
 * (ii) ONLY the Software driver source files ENC28J60.c, ENC28J60.h,
 *		ENCX24J600.c and ENCX24J600.h ported to a non-Microchip device
 *		used in conjunction with a Microchip ethernet controller for
 *		the sole purpose of interfacing with the ethernet controller.
 *
 * You should refer to the license agreement accompanying this
 * Software for additional information regarding your rights and
 * obligations.
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * MICROCHIP BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 *
 * Author               Date      Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * E. Wood     			4/26/08	  Moved from MainDemo.c
 ********************************************************************/
#define __LEGACYHTTPAPP_C

#include "h/TCPIPConfig.h"

#if defined(STACK_USE_HTTP_SERVER)

#include "h/clock.h"
#include "h/TCPIP.h"
#include "h/MainDemo.h"
#include "h/helpers.h"

extern BYTE sendEmailPending;
extern char sendEmailFile[SHORT_STRING_MAX];
extern char sendEmailSubject[SHORT_STRING_MAX];
extern DWORD extractNumber(char*);
extern DWORD lastPing;
extern IP_ADDR lastPingIP;
extern DWORD lastFTP;
extern long lastFTPResult;
extern IP_ADDR lastFTPIP;
extern VARIABLE_TYPE variable[NUM_VARS];
extern void ftoa(char*, float, int);
extern BYTE* strcpyram2ram(BYTE*, BYTE*);
extern BYTE defaultbForceUpdate;
extern long NTPTimezone;
extern char NTPServer[];
extern char DynDNSIPServer[];
extern BYTE emailAddress[];
extern BYTE emailMessageBody[];
extern BYTE emailServer[];
extern BYTE emailFrom[];
extern BYTE emailSubject[];
extern BYTE emailPending;
extern BYTE emailFile[];

void createSettingsFile(char*);

//////////////////////////////////////////////////////////////////////////////////////////
// NOTE: The following HTTP code pretains to the old HTTP server.
//       Upgrading to HTTP2 is *strongly* recommended for all new designs.
//       Custom control of HTTP2 is implemented in CustomHTTPApp.c
//////////////////////////////////////////////////////////////////////////////////////////

#define ENABLE_REMOTE_CONFIG

// CGI Variable codes. - There could be 00h-FFh variables.
// NOTE: When specifying variables in your dynamic pages (.cgi),
//       use the hexadecimal numbering scheme and always zero pad it
//       to be exactly two characters.  Eg: "%04", "%2C"; not "%4" or "%02C"

//
// The variables from 00 - TOTAL-SETTINGS are automatically taken from the settingsNames table.
//

// OUTPUTS
#define VAR_PERMISSION0			(0xB0)
#define VAR_PERMISSION1			(0xB1)
#define VAR_PERMISSION2			(0xB2)
#define VAR_PERMISSION3			(0xB3)
#define VAR_PERMISSION4			(0xB4)
#define VAR_PERMISSION5			(0xB5)
#define VAR_PERMISSION6			(0xB6)
#define VAR_PERMISSION7			(0xB7)
#define VAR_PERMISSION8			(0xB8)
#define VAR_PERMISSION9			(0xB9)
#define VAR_PERMISSION10		(0xBA)
#define VAR_PERMISSION11		(0xBB)
#define VAR_PERMISSION12		(0xBC)

#define VAR_VAR0VALUE           (0xD0)
#define VAR_VAR1VALUE           (0xD1)
#define VAR_VAR2VALUE           (0xD2)
#define VAR_VAR3VALUE           (0xD3)
#define VAR_VAR0RAW             (0xD8)
#define VAR_VAR1RAW             (0xD9)
#define VAR_VAR2RAW             (0xDA)
#define VAR_VAR3RAW             (0xDB)
#define VAR_VAR0LOGNUM          (0xC0)
#define VAR_VAR1LOGNUM          (0xC1)
#define VAR_VAR2LOGNUM          (0xC2)
#define VAR_VAR3LOGNUM          (0xC3)
#define VAR_DIGIN0       		(0xF0)	// Momentary push button inputs
#define VAR_DIGIN1       		(0xF1)
#define VAR_DIGIN2       		(0xF2)
#define VAR_DIGIN3       		(0xF3)
//#define VAR_DHCP                (0xF4)
// LEDS
//#define VAR_LED0				(0xF5)	// LED Outputs
//#define VAR_LED1				(0xF6)
// System
#define VAR_MAC_ADDRESS     	(0xE0)	
#define VAR_FIRMWARE_VERSION 	(0xE1)
#define VAR_NTP_TIME		 	(0xE2)
#define VAR_DYNDNS_PUBLIC_IP	(0xE3)
// SD card variables
#define VAR_SD_CARD_FREE_MB		(0xE8)
#define VAR_SD_CARD_TOTAL_MB	(0xE9)
#define VAR_SD_CARD_PNM			(0xEA)
#define VAR_SD_CARD_PSN			(0xEB)
#define VAR_SD_CARD_CARD_TYPE	(0xEC)
#define VAR_SD_CARD_PRV			(0xED)
// Ping
#define VAR_LAST_PING			(0xEE)
#define VAR_LAST_PING_IP		(0xEF)
#define VAR_LAST_FTP_RESULT     (0xDD)
#define VAR_LAST_FTP			(0xDE)
#define VAR_LAST_FTP_IP		    (0xDF)

//
#endif //STACK_USE_HTTP_SERVER

/*********************************************************************
 * Function:        void HTTPExecCmd(BYTE** argv, BYTE argc)
 *
 * PreCondition:    None
 *
 * Input:           argv        - List of arguments
 *                  argc        - Argument count.
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This function is a "callback" from HTTPServer
 *                  task.  Whenever a remote node performs
 *                  interactive task on page that was served,
 *                  HTTPServer calls this functions with action
 *                  arguments info.
 *                  Main application should interpret this argument
 *                  and act accordingly.
 *
 *                  Following is the format of argv:
 *                  If HTTP action was : thank.htm?name=Joe&age=25
 *                      argv[0] => thank.htm
 *                      argv[1] => name
 *                      argv[2] => Joe
 *                      argv[3] => age
 *                      argv[4] => 25
 *
 *                  Use argv[0] as a command identifier and rests
 *                  of the items as command arguments.
 *
 * Note:            THIS FUNCTION IS DEPRECATED BY HTTP2
 ********************************************************************/
#if defined(STACK_USE_HTTP_SERVER)
//////////////////////////////////////////////////////////////////////////////////////////
// NOTE: The following HTTP code pretains to the old HTTP server.
//       Upgrading to HTTP2 is *strongly* recommended for all new designs.
//       Custom control of HTTP2 is implemented in CustomHTTPApp.c
//////////////////////////////////////////////////////////////////////////////////////////
//ROM char COMMANDS_OK_PAGE[]   = "INDEX.CGI";
//ROM char CONFIG_UPDATE_PAGE[] = "CONFIG.CGI";
//ROM char CMD_UNKNOWN_PAGE[] = "INDEX.CGI";

// Copy string with NULL termination.
//#define COMMANDS_OK_PAGE_LEN  	(sizeof(COMMANDS_OK_PAGE))
//#define CONFIG_UPDATE_PAGE_LEN  (sizeof(CONFIG_UPDATE_PAGE))
//#define CMD_UNKNOWN_PAGE_LEN    (sizeof(CMD_UNKNOWN_PAGE))

BYTE valBuffer[256];
BYTE resBuffer[256];

extern long httpFilesPermissions[TOTAL_FILE_TYPES];
extern int HTTPUnlocked(void);
extern IP_ADDR lastKnownIP;

// The commands
ROM char* commandsCGI[]
={
"out",					// control digital outputs
"set",					// set a variable
"reset",				// reset the microcontroller
"defaults",				// restore defaults...
"serial",				// write to the serial port.
"permit",               // permissions
"email",				// send an email
"csettings",			// create a settings file...
""
};

static int getCGICommand(char* instr)
{
	int i;

	i=0;
	while(commandsCGI[i][0]!='\0')
	{
	if(!strcmppgm2ram(commandsCGI[i], instr))break;
	i++;
	}
	return i;
}

static void setOutput(BYTE outputNum, BYTE action)
{
	switch(outputNum)
	{
		case 0:
			if(action=='0')BUTTON0_IO=0; else if(action=='1')BUTTON0_IO=1; else BUTTON0_IO^=1;
			break;
		case 1:
			if(action=='0')BUTTON1_IO=0; else if(action=='1')BUTTON1_IO=1; else BUTTON1_IO^=1;
			break;
		case 2:
			if(action=='0')BUTTON2_IO=0; else if(action=='1')BUTTON2_IO=1; else BUTTON2_IO^=1;
			break;
		case 3:
			if(action=='0')BUTTON3_IO=0; else if(action=='1')BUTTON3_IO=1; else BUTTON3_IO^=1;
			break;
		default:
			break;
	}
}

static BYTE* printPermissionString(BYTE* outstr, long value)
{
	if(value & IS_DYNAMIC)outstr=strcpyram2ram((BYTE*)outstr, (BYTE*)"Dynamic, "); else outstr=strcpyram2ram((BYTE*)outstr, (BYTE*)"Static, ");
	if(value & IS_EXECUTABLE)outstr=strcpyram2ram((BYTE*)outstr, (BYTE*)"Executable, "); else outstr=strcpyram2ram((BYTE*)outstr, (BYTE*)"Non Executable, ");
	if(value & REQ_PASSWORD)outstr=strcpyram2ram((BYTE*)outstr, (BYTE*)"Private"); else outstr=strcpyram2ram((BYTE*)outstr, (BYTE*)"Public");
	return outstr;
}

static long extractPermission(char* instr, long* val)
{
    if(!stricmppgm2ram((BYTE*)instr, (BYTE*)"Private"))
    {
        (*val)|=REQ_PASSWORD;
    }
    if(!stricmppgm2ram((BYTE*)instr, (BYTE*)"Public"))
    {
        (*val)&=~REQ_PASSWORD;
    }
    if(!stricmppgm2ram((BYTE*)instr, (BYTE*)"Static"))
    {
        (*val)&=~IS_DYNAMIC;
    }
    if(!stricmppgm2ram((BYTE*)instr, (BYTE*)"Dynamic"))
    {
        (*val)|=IS_DYNAMIC;
    }
    if(!stricmppgm2ram((BYTE*)instr, (BYTE*)"Executable"))
    {
        (*val)|=IS_EXECUTABLE;
    }
    if(!stricmppgm2ram((BYTE*)instr, (BYTE*)"Non Executable"))
    {
        (*val)&=~IS_EXECUTABLE;
    }
    return *val;    
}
    
void HTTPExecCmd(BYTE** argv, BYTE argc)
{
    BYTE command;
    long var;
	int index;
	long val;
	DWORD l;
   
    command = getCGICommand((char*)argv[0]);

    /*
     * Find out the cgi file name and interpret parameters
     * accordingly
     */
    switch(command)
    {
    case 0:

        /*
         * Identify the parameters.
         * Compare it in upper case format.
         */
        if(HTTPUnlocked())
        {
        var = argv[1][0] - '0';
		val = argv[2][0];
		setOutput(var, val);
        }
        break;

    case 1:
		if((HTTPUnlocked())&&(argc > 2u))	// Text provided in argv[2]
		{
			// text is in argv[2]...
			UnencodeURL(argv[2]);
			index=getValueIndex((char*)argv[1], (SETTING*)settingsNames);	
			if(settingsNames[index].resultType!=RESULT_NONE)
			{
			getValueType((char*)resBuffer, (char*)argv[2], settingsNames[index].resultType, (BYTE*)&valBuffer, settingsNames[index].type);
			setValue(index, settingsNames, (BYTE*)&valBuffer, 1);
			putValues();
			}
		}
        break;


	case 2:
		// perform a master reset!!
		if(HTTPUnlocked())asm("reset");
		break;
		// no break required!
	case 3:
		// restore all defaults...
		if(HTTPUnlocked())
		{
			f_unlink(VALUES_FILE);
			asm("reset");
		}
		break;

	case 4:
		// write to the serial port...
		if(HTTPUnlocked())
		{
	        var = argv[1][0] - '0';
			USTA=0x4400;
			switch(var)
			{

				case 0:
					putrsUART(argv[2]);
					putrsUART("\r\n");
					break;
			
				case 1:
					l=extractNumber((char*)argv[2]);
					putcUART((char)l);
					break;
				case 2:
				default:
				putrsUART(argv[2]);
				break;
			}
		}
		break;
		
	case 5:
	    if(HTTPUnlocked())
	    {
    	    var = extractNumber((char*)argv[1]);
    	    if((var>=0)&&(var<TOTAL_FILE_TYPES))
			{
				extractPermission((char*)argv[2], &httpFilesPermissions[var]);
				putValues();  
			}
    	}
    	break;
    	

	case 6:
		// send an email
		if((HTTPUnlocked())&&(!sendEmailPending))
		{
			strcpyram2ram((BYTE*)sendEmailSubject, argv[2]);
			strcpyram2ram((BYTE*)sendEmailFile, argv[1]);
			sendEmailPending=1;
		}
		break;


	case 7:
		// create a settings file...
		if(HTTPUnlocked())
		{
			createSettingsFile((char*)argv[1]);
		}
		break;
    default:
        break;
    }
    //memcpypgm2ram((void*)argv[0], (ROM void*)COMMANDS_OK_PAGE, COMMANDS_OK_PAGE_LEN);
 
}
#endif

/*********************************************************************
 * Function:        WORD HTTPGetVar(BYTE var, WORD ref, BYTE* val)
 *
 * PreCondition:    None
 *
 * Input:           var         - Variable Identifier
 *                  ref         - Current callback reference with
 *                                respect to 'var' variable.
 *                  val         - Buffer for value storage.
 *
 * Output:          Variable reference as required by application.
 *
 * Side Effects:    None
 *
 * Overview:        This is a callback function from HTTPServer() to
 *                  main application.
 *                  Whenever a variable substitution is required
 *                  on any html pages, HTTPServer calls this function
 *                  8-bit variable identifier, variable reference,
 *                  which indicates whether this is a first call or
 *                  not.  Application should return one character
 *                  at a time as a variable value.
 *
 * Note:            Since this function only allows one character
 *                  to be returned at a time as part of variable
 *                  value, HTTPServer() calls this function
 *                  multiple times until main application indicates
 *                  that there is no more value left for this
 *                  variable.
 *                  On begining, HTTPGetVar() is called with
 *                  ref = HTTP_START_OF_VAR to indicate that
 *                  this is a first call.  Application should
 *                  use this reference to start the variable value
 *                  extraction and return updated reference.  If
 *                  there is no more values left for this variable
 *                  application should send HTTP_END_OF_VAR.  If
 *                  there are any bytes to send, application should
 *                  return other than HTTP_START_OF_VAR and
 *                  HTTP_END_OF_VAR reference.
 *
 *                  THIS FUNCTION IS DEPRECATED BY HTTP2
 ********************************************************************/
#if defined(STACK_USE_HTTP_SERVER)

static BYTE VarString[STRING_MAX];
//////////////////////////////////////////////////////////////////////////////////////////
// NOTE: The following HTTP code pretains to the old HTTP server.
//       Upgrading to HTTP2 is *strongly* recommended for all new designs.
//       Custom control of HTTP2 is implemented in CustomHTTPApp.c
//////////////////////////////////////////////////////////////////////////////////////////
extern int HTTPUnlocked(void);
FATFS*	myFileSystemPointer;
extern FATFS fileSystem;

WORD HTTPGetVar(BYTE var, WORD ref, BYTE* val)
{
	// Temporary variables designated for storage of a whole return 
	// result to simplify logic needed since one byte must be returned
	// at a time.
	//DWORD dwTime;
	long l;
	DWORD d;
	float f;
	long decp;
	unsigned char x;
	static BYTE VarStringLen;
	DWORD DataSource;

    if(var<TOTAL_SETTINGS)
    {
    printValueType((char*)VarString, settingsNames[var].resultType, settingsNames[var].value, settingsNames[var].type);
    goto continue_string;
    }
    else
    {
	// Identify variable
    switch(var)
    {
#if(USE_SD_REGISTERS)
	case VAR_SD_CARD_PNM:
		VarString[0]=cardInfo.cid.PNM[0];
		VarString[1]=cardInfo.cid.PNM[1];
		VarString[2]=cardInfo.cid.PNM[2];
		VarString[3]=cardInfo.cid.PNM[3];
		VarString[4]=cardInfo.cid.PNM[4];
		VarString[5]=cardInfo.cid.PNM[5];
		VarString[6]=cardInfo.cid.PNM[6];
		VarString[7]='\0';
		goto continue_string;
	case VAR_SD_CARD_PSN:
		l=(((long)cardInfo.cid.PSN[3])<<24)+(((long)cardInfo.cid.PSN[2])<<16)+(((long)cardInfo.cid.PSN[1])<<8)+((long)cardInfo.cid.PSN[0]);
		goto continue_long;
	case VAR_SD_CARD_PRV:
		l=(long)cardInfo.cid.PRV;
		goto continue_long;
#endif

	case VAR_SD_CARD_CARD_TYPE:
		x=cardInfo.CARD_TYPE;
		if(x==1)
		{
		strcpypgm2ram((char*)VarString, "MMC");
		} else
		if(x==2)
		{
		strcpypgm2ram((char*)VarString, "SD v.1");
		} else
		if(x==4)
		{
		strcpypgm2ram((char*)VarString, "SD v.2");
		} else
		if(x==6)
		{
		strcpypgm2ram((char*)VarString, "SDHC");
		} else
		{
		strcpypgm2ram((char*)VarString, "None");
		}
		goto continue_string;

	case VAR_SD_CARD_TOTAL_MB:
		myFileSystemPointer=&fileSystem;
		if((f_getfree("/", (DWORD*)&d, &myFileSystemPointer))==FR_OK)
		{
			f=(float)((myFileSystemPointer->max_clust - 2) * myFileSystemPointer->csize/2)/1024.0;
		} else f=0;
		decp=1;
		goto continue_variable;

	case VAR_SD_CARD_FREE_MB:
		myFileSystemPointer=&fileSystem;
		if((f_getfree("/", (DWORD*)&d, &myFileSystemPointer))==FR_OK)
		{
			f=(d * myFileSystemPointer->csize / 2)/1024.0;
		} else f=0;
		decp=1;
		goto continue_variable;
/*
	case VAR_SETTINGS_FILE:
          strcpypgm2ram((char*)VarString, (char*)SETTINGS_FILE);
  		  goto continue_string;
	case VAR_VALUES_FILE:
		  strcpypgm2ram((char*)VarString, (char*)VALUES_FILE);
  		  goto continue_string;
	case VAR_LOG_FILE:
		  strcpypgm2ram((char*)VarString, (char*)LOG_FILE);
  		  goto continue_string;

    case VAR_HTTP_UNLOCKED:
        if(HTTPUnlocked())
          strcpypgm2ram((char*)VarString, (char*)"Unlocked");
        else
          strcpypgm2ram((char*)VarString, (char*)"Locked");
        goto continue_string;
    case VAR_LED0:
        *val = LED0_IO ? '1':'0';
        break;
    case VAR_LED1:
        *val = LED1_IO ? '1':'0';
        break;
*/



    case VAR_DIGIN0:
        *val = BUTTON0_IO ? '1':'0';
        break;
    case VAR_DIGIN1:
        *val = BUTTON1_IO ? '1':'0';
        break;
    case VAR_DIGIN2:
        *val = BUTTON2_IO ? '1':'0';
        break;
    case VAR_DIGIN3:
        *val = BUTTON3_IO ? '1':'0';
        break;

	case VAR_FIRMWARE_VERSION:
		decp=2;
		f=FIRMWARE_VERSION;
		goto continue_variable;

#if defined(STACK_USE_ICMP_SERVER)
	case VAR_LAST_PING_IP:
    	DataSource = lastPingIP.Val;
		goto continue_ipaddress;
	case VAR_LAST_PING:
		if(ref == HTTP_START_OF_VAR)
		{
			if(lastPing>0)ascTimeEpoch(VarString, lastPing); else strcpypgm2ram((char*)VarString, "Unknown");
		}
		goto continue_string;
#endif
	case VAR_LAST_FTP_IP:
    	DataSource = lastFTPIP.Val;
		goto continue_ipaddress;
	case VAR_LAST_FTP:
		if(ref == HTTP_START_OF_VAR)
		{
			if(lastFTP>0)ascTimeEpoch(VarString, lastFTP); else strcpypgm2ram((char*)VarString, "Unknown");
		}
		goto continue_string;
	case VAR_LAST_FTP_RESULT:
		if(ref == HTTP_START_OF_VAR)
		{
			if(lastFTPResult==0)strcpypgm2ram((char*)VarString, "Declined"); else if(lastFTPResult==1)strcpypgm2ram((char*)VarString, "Granted"); else strcpypgm2ram((char*)VarString, "Unknown");
		}
		goto continue_string;
	case VAR_NTP_TIME:
        if(ref == HTTP_START_OF_VAR)
		{
			getTimeString(VarString);
		}
		goto continue_string;

    case VAR_MAC_ADDRESS:
        if ( ref == HTTP_START_OF_VAR )
        {
			printValueType((char*)VarString, RESULT_MAC_ADDR, &AppConfig.MyMACAddr.v[0], 0);
        }
		// Send one byte back to the calling function (the HTTP Server)
		goto continue_string;

	case VAR_DYNDNS_PUBLIC_IP:
			DataSource=lastKnownIP.Val;
			goto continue_ipaddress;

/*
    case VAR_DHCP:
    	// Check if ref == 0 meaning that the first character of this 
    	// variable needs to be returned
		l=(long)AppConfig.Flags.bIsDHCPEnabled;
        goto continue_long;
*/
	case VAR_PERMISSION0:
	case VAR_PERMISSION1:
	case VAR_PERMISSION2:
	case VAR_PERMISSION3:
	case VAR_PERMISSION4:
	case VAR_PERMISSION5:
	case VAR_PERMISSION6:
	case VAR_PERMISSION7:
	case VAR_PERMISSION8:
	case VAR_PERMISSION9:
	case VAR_PERMISSION10:
	case VAR_PERMISSION11:
	case VAR_PERMISSION12:
		if(ref==HTTP_START_OF_VAR)
		{
			printPermissionString(VarString, httpFilesPermissions[var-VAR_PERMISSION0]);
		}
		goto continue_string;

    case VAR_VAR0VALUE:
        f=variable[0].value;
        decp=variable[0].decp;
        goto continue_variable;
    case VAR_VAR1VALUE:           
        f=variable[1].value;
        decp=variable[1].decp;
        goto continue_variable;
    
    case VAR_VAR2VALUE:           
        f=variable[2].value;
        decp=variable[2].decp;
        goto continue_variable;
    case VAR_VAR3VALUE:           
        f=variable[3].value;
        decp=variable[3].decp;
        goto continue_variable;
    case VAR_VAR0RAW:             
        f=variable[0].raw;
        decp=variable[0].decp;
        goto continue_variable;
    case VAR_VAR1RAW:             
        f=variable[1].raw;
        decp=variable[1].decp;
        goto continue_variable;
    case VAR_VAR2RAW:             
        f=variable[2].raw;
        decp=variable[2].decp;
        goto continue_variable;
    case VAR_VAR3RAW:
        f=variable[3].raw;
        decp=variable[3].decp;
        goto continue_variable;
    case VAR_VAR0LOGNUM:          
        l=(long)variable[0].lognum;
        goto continue_long;
    case VAR_VAR1LOGNUM:         
        l=(long)variable[1].lognum;
        goto continue_long;
    case VAR_VAR2LOGNUM:          
        l=(long)variable[2].lognum;
        goto continue_long;
    case VAR_VAR3LOGNUM:          
        l=(long)variable[3].lognum;
        goto continue_long;
continue_ipaddress:
		printValueType((char*)VarString, RESULT_IP_ADDR, (BYTE*)&DataSource, 0);
		goto continue_string;
continue_long:
    	printValueType((char*)VarString, RESULT_INT, (BYTE*)&l, 0);
    	goto continue_string;
continue_variable:
		if(ref==HTTP_START_OF_VAR)
		{
			ftoa((char*)&VarString[0], f, (int)decp);
		}
		goto continue_string;
continue_string:
	    VarStringLen = strlen((char*)VarString);
		*val=VarString[(BYTE)ref];
		if(VarString[(BYTE)ref]=='\0')
			return HTTP_END_OF_VAR;
		else if(VarString[(BYTE)++ref]=='\0')
			return HTTP_END_OF_VAR;
		return ref;
	default:
		strcpypgm2ram((char*)VarString, (char*)"Unknown");
		goto continue_string;
	}
    return HTTP_END_OF_VAR;
    }
    return HTTP_END_OF_VAR;
}
#endif

#if defined(STACK_USE_FTP_SERVER) && defined(STACK_USE_MPFS)
//////////////////////////////////////////////////////////////////////////////////////////
// NOTE: The following FTP code is deprecated.
//       If your application has upgraded to HTTP2, you can upload MPFS 
//       images directly through the MPFS2.exe utility without using FTP.
//       This upload will occur over HTTP, and therefore FTP is unnecessary.
//////////////////////////////////////////////////////////////////////////////////////////
extern char userName[];
extern char passWord[];

BOOL FTPVerify(BYTE *login, BYTE *password)
{
	if((!strcmpram2ram(login, (BYTE*)userName)) && (!strcmpram2ram(password, (BYTE*)passWord)))return TRUE;
    return FALSE;
}

#endif
